# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [2.5.1] - 2026-01-15

### Added

- New layout for Flasher function with list of flashes. The progress of flash and ability to cancel it (possible for some devices and at the right time) is displayed in the flash section within the list. It is also possible to flash multiple devices at the same time.
- Automatically move the app window to visible area if according to settings it would be displayed outside of the screen (it could happen when moving app files between PCs with different resolutions).

### Changed

- Divide Discovery and Flasher functions in UI. They no longer share progressbar and status (it could behave oddly when used both at the same time).

### Fixed

- Update texts in UI to be more consistent and clear.
- Sorting order when sorted by IP address (eg. in ascending order 192.168.1.4 would appear after 192.168.1.10).
- Sorting and filtering items. Sorting was not preserved after using filtering.

## [2.4.0] - 2025-03-27

### Changed

- Accept host (IP, domain, or base URL) in place of IP address. Thanks to that, flashing can be used with non standard ports and HTTPS.

## [2.3.0] - 2024-12-17

### Added

- Filter/search Discovery results by all fields.

## [2.2.0] - 2024-11-22

### Added

- Support for new LK3.9 version in Discovery and Get the latest firmware functions.

## [2.1.1] - 2024-10-21

### Added

- Context menu to Discovery section with functions to copy IP or MAC, use IP in Flasher and view in web browser.
- Support for new LK4 mini version in Discovery function.

## [2.0.1] - 2024-05-22

### Fixed

- Flashing to work when HTTPS is enabled on the target.

## [2.0.0] - 2024-02-26

### Added

- Support for LK4 mini.
- Sorting discovery results by column (click column header to sort by this property in ascending, descending or input order).

### Removed

- Support for Windows XP.

## [1.3.2] - 2023-09-06

### Added

- Ability to flash LK4 and tcPDU.

## [1.2.0] - 2022-08-26

### Added

- Option to cancel flashing (as long as there is no transfer).

### Changed

- Upgrade tftpy version and change how its fix is applied.
- Merge cmd exe with main exe - in result it can be called by external programs, eg. `LKTools.exe discovery` will run discovery function and return the results. Note that there is no console window, so it cannot be simply used in cmd.

## [1.1.8] - 2021-10-15

### Changed

- Increase wait time for devices responses to discovery packet (from 1s to 2s).
- Run discovery for all available IP addresses on PC. In result, the discovery should work when there are multiple IP addresses on single interface. Note, that in case of multiple IP addresses within the same network class, the discovery results might be odd, eg. duplicated LKs.

## [1.1.7] - 2021-08-09

### Changed

- Reduce timeout for flashing HW 2.X, as the time window for it is way shorter than in case of HW 3.X.

## [1.1.6] - 2021-04-20

### Added

- Simple modals after flashing, so it's clearer that it finished.

### Changed

- Layout of Flasher form to be more intuitive - select a firmware, select IP address of device (when using Discovery it might be already selected), flash the firmware.
- More precise descriptions in the Discovery part.

## [1.1.5] - 2021-03-25

### Changed

- The `Get latest firmware` function contains a link to the firmware changes list under the `View changelog` button.

### Fixed

- The `Get latest firmware` function works properly for devices with strange names, containing high-code Unicode characters.

## [1.1.4] - 2021-03-19

### Fixed

- Flashing LK on Windows XP.

## [1.1.2] - 2021-03-16

### Fixed

- The Discovery function now lists LK with strange names, containing high-code Unicode characters.

## [1.1.1] - 2021-03-02

### Changed

- Increase TFTP timeout to better avoid LK3 getting stuck at bootloader, what then required using `Flash firmware` again.

## [1.1.0] - 2021-02-26

### Added

- Add a link to the download page to the Help menu.

### Changed

- Increase wait time for devices responses to discovery packet, so discovery yields more consistent results.
- The `Get latest firmware` function recognizes the LK HW 2.0, 2.5, 3.5 power strip versions and no longer proposes a standard firmware for them.
- The `Get latest firmware` function reuses once downloaded firmware files (when used multiple times for the same HW it will download the firmware file just once).
- The `Get latest firmware` no longer prompts user to confirm downloading the file, but only to confirm flashing the device with it.

### Fixed

- The `Get latest firmware` properly recognizes LK HW 3.0 SW 1.00-1.52 and works for them.

## [1.0.3] - 2020-12-31

### Fixed

- Enabling upgrade on LK HW 3.X when flashing (option in Access tab).

## [1.0.2] - 2020-12-28

### Fixed

- Increased number of flash attempts with shorter delay between them to improve flashing LK HW 2.5.
- Fixed remembering LK IP address from latest successful flashing.

## [1.0.1] - 2020-12-21

### Added

- Prompt user whether to flash the device after downloading firmware.

## [1.0.0] - 2020-12-18

### Added

- Function to get latest firmware for device.

### Changed

- Change layout from tabbed to single frame with splitter in middle.
- Simplify flashing setup. Remove `Try to enable bootloader on LK before flashing` and `HW Version` options from Flasher. App tries to check HW version and start bootloader, after these attempts (successful or not) flashes selected firmware onto the device.

## [0.7.8] - 2020-07-27

### Fixed

- Fix remembering firmwares which were successfully flashed to device.

## [0.7.7] - 2020-06-22

### Changed

- Change timeout for tftp client (5 -> 8 seconds) to work even with 30s delay for DHCP.

## [0.7.6] - 2020-06-19

### Fixed

- Fix discovery when there are multiple gateways on one interface.

## [0.7.4] - 2020-06-15

- Application for discovering LK in networks and flashing them with firmware.
